package gov.va.med.mhv.getcare.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.converter.FacilityInfoConveter;
import gov.va.med.mhv.getcare.common.dto.WellnessPreferenceDTO;
import gov.va.med.mhv.getcare.model.WellnessPreference;

@Component
public class WellnessPreferenceConverter implements Converter<WellnessPreference, WellnessPreferenceDTO> {

	@Autowired
	private FacilityInfoConveter facilityInfoConveter;

	@Override
	public WellnessPreferenceDTO convert(WellnessPreference source) {
		WellnessPreferenceDTO target = new WellnessPreferenceDTO();

		target.setId(source.getId());
		target.setFacilityInfoId(source.getFacilityInfoId());
		target.setPhrFacilityControlId(source.getPhrFacilityControlId());
		target.setPatientId(source.getPatientId());

		if (null != source.getFacilityInfo()) {
			target.setFacilityInfo(facilityInfoConveter.convertDomainFacilityInfo(source.getFacilityInfo()));
		}

		return target;
	}

	public WellnessPreference convert(WellnessPreferenceDTO source) {
		WellnessPreference target = new WellnessPreference();

		target.setId(source.getId());
		target.setFacilityInfoId(source.getFacilityInfoId());
		target.setPhrFacilityControlId(source.getPhrFacilityControlId());
		target.setPatientId(source.getPatientId());
		
		if (null != source.getFacilityInfo()) {
			target.setFacilityInfo(facilityInfoConveter.convertDTOFacilityInfo(source.getFacilityInfo()));
		}

		return target;
	}
}
